/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.coobird.thumbnailator.util.exif.ExifUtils;
import net.coobird.thumbnailator.util.exif.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSource
extends AbstractImageSource<File> {
    private static final int FIRST_IMAGE_INDEX = 0;
    private final File sourceFile;

    public FileImageSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = file;
    }

    public FileImageSource(String string2) {
        if (string2 == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = new File(string2);
    }

    @Override
    public BufferedImage read() throws IOException {
        Object object;
        Object object2;
        if (!this.sourceFile.exists()) {
            throw new FileNotFoundException("Could not find file: " + this.sourceFile.getAbsolutePath());
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.sourceFile);
        if (imageInputStream == null) {
            throw new IOException("Could not open file: " + this.sourceFile.getAbsolutePath());
        }
        Iterator<ImageReader> iterator2 = ImageIO.getImageReaders(imageInputStream);
        if (!iterator2.hasNext()) {
            String string2 = this.sourceFile.getPath();
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for " + string2 + ".");
        }
        ImageReader imageReader = iterator2.next();
        imageReader.setInput(imageInputStream);
        this.inputFormatName = imageReader.getFormatName();
        try {
            if (this.param.useExifOrientation() && (object2 = ExifUtils.getExifOrientation(imageReader, 0)) != null && object2 != Orientation.TOP_LEFT) {
                object = this.param.getImageFilters();
                object.add(0, ExifFilterUtils.getFilterForOrientation(object2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = imageReader.getDefaultReadParam();
        int n = imageReader.getWidth(0);
        int n2 = imageReader.getHeight(0);
        if (this.param != null && this.param.getSourceRegion() != null) {
            Region region = this.param.getSourceRegion();
            Rectangle rectangle = region.calculate(n, n2);
            ((IIOParam)object).setSourceRegion(rectangle);
        }
        if (this.param != null && "true".equals(System.getProperty("thumbnailator.conserveMemoryWorkaround")) && n > 1800 && n2 > 1800 && (long)(n * n2 * 4) > Runtime.getRuntime().freeMemory() / 4L) {
            int n3 = 1;
            if (this.param.getSize() != null && this.param.getSize().width * 2 < n && this.param.getSize().height * 2 < n2) {
                double d = (double)n / (double)this.param.getSize().width;
                double d2 = (double)n2 / (double)this.param.getSize().height;
                n3 = (int)Math.floor(Math.min(d, d2));
            } else if (this.param.getSize() == null) {
                n3 = (int)Math.max(1.0, Math.floor(1.0 / Math.max(this.param.getHeightScalingFactor(), this.param.getWidthScalingFactor())));
            }
            while (n / n3 < 600 || n2 / n3 < 600) {
                --n3;
            }
            if (this.param.getSize() == null) {
                try {
                    Class<?> clazz2 = this.param.getClass();
                    Field field2 = clazz2.getDeclaredField("heightScalingFactor");
                    Field field3 = clazz2.getDeclaredField("widthScalingFactor");
                    field2.setAccessible(true);
                    field3.setAccessible(true);
                    field2.set(this.param, this.param.getHeightScalingFactor() * (double)n3);
                    field3.set(this.param, this.param.getWidthScalingFactor() * (double)n3);
                }
                catch (Exception exception) {
                    n3 = 1;
                }
            }
            ((IIOParam)object).setSourceSubsampling(n3, n3, 0, 0);
        }
        object2 = imageReader.read(0, (ImageReadParam)object);
        imageReader.dispose();
        imageInputStream.close();
        return (BufferedImage)((Object)this.finishedReading(object2));
    }

    @Override
    public File getSource() {
        return this.sourceFile;
    }
}

